/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/
#include "TextNode.hh"
#include "TextureManager.hh"
#include <sstream>
#include <plib/fnt.h>

namespace top10 {
namespace graphX {

TextNode::TextNode():
  posx(0),
  posy(0),
  pt_size(50.0),
  italic(false),
  font(0)
{
}

void TextNode::buildRenderList(RenderState s, RenderList* rl, const CameraNode& c) const
{
  if (!font) return;
  
  s.toggleExternal(true);
  rl->insert(std::make_pair(s, this)); 
}

void TextNode::renderGL(const RenderingFeatures& features, const RenderState&, const CameraNode&) const
{
  if (!font) return;
#if 0
  glDisable(GL_TEXTURE_2D);
  glColor4f(1.0, 1.0, 1.0, 1.0);

  float left, right, bot, top;
  font->getBBox(text.c_str(), pt_size, italic?10.0:0.0, &left, &right, &bot, &top);

  glBegin(GL_TRIANGLE_STRIP);
  glVertex3f(posx+ left, posy+ bot, 0.0);
  glVertex3f(posx+ left, posy+ top, 0.0);
  glVertex3f(posx+ right, posy+ bot, 0.0);
  glVertex3f(posx+ right, posy+ top, 0.0);
  glEnd();
#else
  assert(glGetError() == GL_NO_ERROR);

  /* Set the texture function to modulate, to make it posible to control the color of the text.
     Note: Apparently, the texture function is not saved in the texture object.
  */
  glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

  sgVec3 pos = {posx, posy, 0.0};
  font->begin();
  assert(glGetError() == GL_NO_ERROR);
  font->puts(pos, pt_size, italic? pt_size*10.0 : 0.0, text.c_str());
  assert(glGetError() == GL_NO_ERROR);
  font->end();
  assert(glGetError() == GL_NO_ERROR);

  // Following texture state changes (if any) must not affect plib's texture object.
  glBindTexture(GL_TEXTURE_2D, 0);

#endif
}

void TextNode::setTime(unsigned int t)
{
  std::ostringstream buf;
  
  unsigned int ms = t % 1000;
  t/=1000;
  unsigned int s = t % 60;
  t/=60;
  unsigned int m = t;
  
  buf<<m<<":";
  if (s < 10) buf<<"0";
  buf<<s<<".";
  if (ms < 100) buf<<"0";
  if (ms < 10)  buf<<"0";
  buf<<ms;
  
  text = buf.str();
}

void TextNode::setNum(double val, unsigned int precision)
{
  std::ostringstream buf;
  buf.precision(precision);
  buf << val;
  text = buf.str();
}

}
}
