/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "TexGenModeNode.hh"

namespace top10
{
namespace graphX
{

  TexGenModeNode::TexGenModeNode()
    : mode(RenderState::Explicit)
  {
  }

  void TexGenModeNode::setExplicit()
  {
    mode = RenderState::Explicit;
  }

  void TexGenModeNode::setNormalMap()
  {
    mode = RenderState::Normal;
  }

  void TexGenModeNode::setReflectionMap()
  {
    mode = RenderState::Reflective;
  }

  void TexGenModeNode::setLinear()
  {
    mode = RenderState::ObjectLinear;
  }

  void TexGenModeNode::setEyeLinear()
  {
    mode = RenderState::EyeLinear;
  }

  void TexGenModeNode::setSphereMap()
  {
    mode = RenderState::Spherical;
  }

  void TexGenModeNode::setMode(RenderState::TexCoordGenMode m)
  {
    mode = m;
  }

  void TexGenModeNode::modifyRenderState(RenderState& s, const CameraNode&) const
  {
    s.setTexGenMode(mode);
  }

}
}
