/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHXSKYBOXNODE_HH
#define TOP10_GRAPHXSKYBOXNODE_HH

#include "PanelNode.hh"
#include "TextureNode.hh"
#include "TransformNode.hh"

namespace top10 {
namespace graphX {

class SkyBoxNode: public top10::graphX::Node
{
public:
  enum Direction {Front=0, Left=1, Back=2, Right=3, Top=4, Bottom=5};

  //! Uses "Sunset" skybox.
  SkyBoxNode();

  //! Uses a specific skybox.
  SkyBoxNode(const std::string& texture_dir);

  //! Change the texture of a face
  void setFace(Direction, unsigned int texture_id);
  void setFace(Direction, const std::string&);

  //! 0<idx<6
  Node* getChild(int idx) const;

  //! Do nothing
  inline void addChild(Node*) {}

  //! Do nothing
  inline void removeChild(Node*) {}

  inline void renderGL(const RenderingFeatures&, const RenderState&, const CameraNode&) const {}

protected:
  void modifyRenderState(RenderState& s, const CameraNode&) const;

private:
  void init(const std::string&);
  top10::util::Ref<TransformNode> children[6];
  top10::util::Ref<TextureNode> textures[6];
  top10::util::Ref<PanelNode> panels[6];
};

}

}

#endif
