/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "SkyBoxNode.hh"
#include "TextureManager.hh"

namespace top10 {
namespace graphX {

SkyBoxNode::SkyBoxNode(const std::string& skybox_dir)
{
  init(skybox_dir);
}

SkyBoxNode::SkyBoxNode()
{
  init("Sunset");
}

void SkyBoxNode::init(const std::string& skybox_dir)
{
  for (int i=0; i<6; ++i) {
    children[i] = new TransformNode;
    textures[i] = new TextureNode;
    textures[i]->setFiltering(RenderState::Trilinear);
    panels[i] = new PanelNode;
    panels[i]->setTextureOffset(0.001);
    children[i]->addChild(textures[i].getPtr());
    textures[i]->addChild(panels[i].getPtr());
  }

  double m[4][4] = {
    { 0, 0, 1, 0},
    { 0, 1, 0, 0},
    {-1, 0, 0, 0},
    { 0, 0, 0, 1}
  };
  
  top10::math::Matrix4 M(m);
  top10::math::Matrix4 T;
  T = top10::math::Identity4();
  
  for (int i=0; i<4; ++i) {
    children[i]->setToWorld(T);
    T = M*T;
  }
  
  double m2[4][4] = {
    {1, 0, 0, 0},
    {0, 0,-1, 0},
    {0, 1, 0, 0},
    {0, 0, 0, 1}
  };
  children[Top]->setToWorld(top10::math::Matrix4(m2));
  
  double m3[4][4] = {
    {1, 0, 0, 0},
    {0, 0, 1, 0},
    {0,-1, 0, 0},
    {0, 0, 0, 1}
  };
  children[Bottom]->setToWorld(top10::math::Matrix4(m3));

  textures[Front]->setTextureId(TextureManager::getInstance()->getTexture(skybox_dir + "/front.jpg"));
  textures[Left]->setTextureId(TextureManager::getInstance()->getTexture(skybox_dir + "/left.jpg"));
  textures[Back]->setTextureId(TextureManager::getInstance()->getTexture(skybox_dir + "/back.jpg"));
  textures[Right]->setTextureId(TextureManager::getInstance()->getTexture(skybox_dir + "/right.jpg"));
  textures[Top]->setTextureId(TextureManager::getInstance()->getTexture(skybox_dir + "/top.jpg"));
  textures[Bottom]->setTextureId(TextureManager::getInstance()->getTexture(skybox_dir + "/bottom.jpg"));
}

void SkyBoxNode::setFace(Direction d, unsigned int texture_id)
{
  textures[d]->setTextureId(texture_id);
}

void SkyBoxNode::setFace(Direction d, const std::string& s)
{
  setFace(d, TextureManager::getInstance()->getTexture(s));
}

Node* SkyBoxNode::getChild(int idx) const
{
  if (idx>=0 && idx<6) return children[idx].getPtr();
  else return 0;
}

void SkyBoxNode::modifyRenderState(RenderState& s, const CameraNode&) const
{
  s.setColor(255, 255, 255);
}

}
}
