/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "RenderingFeatures.hh"
#include "util/Log.hh"
#include "util/strconv.hh"

#include "extras/GLee.h"
#include <string>
#include <iostream>

namespace top10 {

namespace graphX {

using top10::util::Log;

RenderingFeatures::RenderingFeatures():
  hasAnisotropicFiltering(false),
  maxAnisotropy(0.0),
  hasMultiTexturing(false),
  maxMultiTextures(0),
  hasCubeMaps(false)
{
  std::string extensions = (char*)glGetString(GL_EXTENSIONS);
#ifdef GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT
  if (extensions.find("GL_EXT_texture_filter_anisotropic") != std::string::npos) {
    hasAnisotropicFiltering = true; 
    glGetFloatv(GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT, &maxAnisotropy);
    
    Log::getSingle()->send(Log::Info, "RenderingFeatures", std::string("Anisotropic filtering available x") + top10::util::toString(maxAnisotropy));
  }
#else
#warning "GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT undefined"
#endif

  if (extensions.find("GL_ARB_multitexture") != std::string::npos
    && extensions.find("GL_EXT_texture_env_combine") != std::string::npos)
  {
    hasMultiTexturing = true;
    glGetIntegerv(GL_MAX_TEXTURE_UNITS_ARB,&maxMultiTextures);
    Log::getSingle()->send(Log::Info, "RenderingFeatures", std::string("Multitexturing available (") + top10::util::toString(maxMultiTextures) + std::string(")"));
  }

  if (extensions.find("GL_ARB_texture_cube_map") != std::string::npos
    || extensions.find("GL_EXT_texture_cube_map") != std::string::npos)
  {
    hasCubeMaps = true;
    Log::getSingle()->send(Log::Info, "RenderingFeatures", "Cube maps available");
  }
}

}
}
