/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "PanelNode.hh"

namespace top10 {
namespace graphX {

PanelNode::PanelNode()
: offset(0.0)
{
  x[0] = -10.0;
  y[0] = -10.0;
  x[1] = 10.0;
  y[1] = 10.0;
  z = -10.0;
}

void PanelNode::setTextureOffset(double d)
{
  offset = d;
}

void PanelNode::renderGL(const RenderingFeatures& unused, const RenderState&, const CameraNode&) const
{
  glBegin(GL_TRIANGLE_STRIP);
  
  glNormal3f(0.0, 0.0, 1.0);

  glTexCoord2d(offset, offset);
  glVertex3f(x[0], y[1], z);
  
  glTexCoord2d(offset, 1.0-offset);
  glVertex3f(x[0], y[0], z);
  
  glTexCoord2d(1.0-offset, offset);
  glVertex3f(x[1], y[1], z);

  glTexCoord2d(1.0-offset, 1.0-offset);
  glVertex3f(x[1], y[0], z);
  
  glEnd();    
}

}
}
