/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "NodeProxy.hh"

namespace top10 {
namespace graphX {
NodeProxy::NodeProxy(const Node* node, const ProxyOperation* op, bool store):
  original(node), op(op), store(store)
{}

Node* NodeProxy::getChild(int idx) const
{
  if (original->getChild(idx) == 0) return 0;
    
  Node* ret;
  if (!store || idx >= stored.size() || !stored.at(idx).isValid()) {
    ret = makeChild(idx);
    if (store)
    {
      NodeRef null;
      for (int i=stored.size(); i<=idx; ++i)
	stored.push_back(null); 
      stored[idx] = ret;
    }
  }
  else {
    ret = stored[idx].getPtr();
  }
  
  return ret;
}

Node* NodeProxy::makeChild(int idx) const
{
  if (original->getChild(idx) == 0) return 0;
      
  TransformNode* transform_node = dynamic_cast<TransformNode*>(original->getChild(idx));
  if (transform_node) return new TransformNodeProxy(transform_node, op.getPtr(), store);
            
  MeshNode* mesh_node = dynamic_cast<MeshNode*>(original->getChild(idx));
  if (mesh_node) return op->makeChild(mesh_node);
      
  Node* node = original->getChild(idx);
  return new NodeProxy(node, op.getPtr(), store);
}

TransformNodeProxy::TransformNodeProxy(const TransformNode* n, const ProxyOperation* op, bool b):
  NodeProxy(n, op, b),
  original(n)
{}

void TransformNodeProxy::modifyRenderState(RenderState& s, const CameraNode&) const {
  s.setTransform(s.getTransform()*original->toWorld());
}

}
}
