/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Node.hh"

using namespace top10::graphX;

Node::Node(): fixed_flags(0)
{
}

void Node::buildRenderList(RenderState rs, RenderList* rl, const CameraNode& c) const
{
  modifyRenderState(rs, c);
  rs.disableChanges(fixed_flags);

  for_all_children(this, child) {
    child->buildRenderList(rs, rl, c);
  }
  for_all_children_end;    
}

Node* Node::find(std::string n)
{
  if (name == n) return this;
  
  Node* ret;
  for_all_children(this, child) {
    ret = child->find(n);
    if (ret) return ret;
  }
  for_all_children_end;

  return 0;
}
