/*
  Top10, a racing simulator
  Copyright (C) 2000-2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_GRAPHX_MESH_MARKER_HH
#define TOP10_GRAPHX_MESH_MARKER_HH

#include "Wireframe.hh"
#include "MaterialNode.hh"
#include "CullNode.hh"

namespace top10
{
  namespace graphX
  {
    //! Emphasize a mesh.
    /*! Implemented by drawing an outline around the mesh.
    */
    class MeshMarker: public Node
    {
    public:
      MeshMarker();
      virtual ~MeshMarker();

      Node* getChild(int idx) const;
      void addChild(Node*);
      void removeChild(Node*);
      void buildRenderList(RenderState, RenderList*, const CameraNode&) const;
      void renderGL(const RenderingFeatures&, const RenderState&, const CameraNode&) const {};

    private:
      top10::util::Ref<Wireframe> wf_node;
      top10::util::Ref<MaterialNode> color_node;
      top10::util::Ref<CullNode> cull_node;
      top10::util::Ref<GroupNode> children;
    };
  };
};

#endif
