/*
  Top10, a racing simulator
  Copyright (C) 2000-2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "MeshMarker.hh"

namespace top10
{
  namespace graphX
  {

    MeshMarker::MeshMarker()
    {
      wf_node = new Wireframe;
      color_node = new MaterialNode;
      children = new GroupNode;
      cull_node = new CullNode;

      // Red outline
      color_node->r = 255;
      color_node->g = color_node->b = 0;

      // Thick outline
      wf_node->setThickness(3.0);

      // Render back faces only
      cull_node->setCulling(RenderState::Front);

      // Build hierarchy: (cull_node, color_node) -> wf_node -> children
      cull_node->addChild(color_node.getPtr());
      color_node->addChild(wf_node.getPtr());
      wf_node->addChild(children.getPtr());
    }

    MeshMarker::~MeshMarker()
    {
    }

    Node* MeshMarker::getChild(int idx) const
    {
      return children->getChild(idx);
    }

    void MeshMarker::addChild(Node* node)
    {
      children->addChild(node);
    }

    void MeshMarker::removeChild(Node* node)
    {
      children->removeChild(node);
    }

    void MeshMarker::buildRenderList(RenderState rs, RenderList* rl, const CameraNode& c) const
    {
      cull_node->buildRenderList(rs, rl, c);
    }

  };
};
