/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHX_LIGHT_HH
#define TOP10_GRAPHX_LIGHT_HH

#include "extras/GLee.h"
#include "math/Vertex.hh"

namespace top10 {
  namespace graphX {

    class Light {
    public:
      enum LightType {
	SolarLight=0, PointLight=1 /*, SpotLight*/
      };

    public:
      //! Default light: SolarLight
      Light();
      Light(LightType t);

      inline LightType getType() const { return type; }
      inline top10::math::Vector getPosition() const { return pos; }
      inline top10::math::Vector getDirection() const { return dir; }

      inline void setType(LightType t) { type = t; }
      inline void setPosition(top10::math::Vector p) { pos = p; }
      inline void setDirection(top10::math::Vector d) { dir = d; }

      void setLightGL(GLenum) const;
      
      bool operator<(const Light& other) const;
      inline bool operator!=(const Light& other) const {
	return type != other.type || pos != other.pos || dir != other.dir;
      }

    private:
      LightType type;
      top10::math::Vector pos;
      top10::math::Vector dir;
      float diffuse[4];
      float ambient[4];
    };

  };
};
#endif
