/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "Light.hh"

using namespace top10::graphX;

Light::Light(): type(SolarLight), pos(0,0,0), dir(1,-1,0)
{
  float white[] = {1.0, 1.0, 1.0, 1.0};
  for (int i=0; i<4; ++i) {
    diffuse[i] = white[i];
    ambient[i] = white[i] * 0.6;
  }  
}

Light::Light(LightType t): type(t), pos(0,0,0), dir(1,-1,0)
{
  float white[] = {1.0, 1.0, 1.0, 1.0};
  for (int i=0; i<4; ++i) {
    diffuse[i] = white[i];
    ambient[i] = white[i] / 5.0;
  }    
}

bool Light::operator<(const Light& other) const
{
  if (type != other.type) return type < other.type;
  if (pos.x != other.pos.x) return pos.x < other.pos.x;
  if (pos.y != other.pos.y) return pos.y < other.pos.y;
  if (pos.z != other.pos.z) return pos.z < other.pos.z;
  if (dir.x != other.dir.x) return dir.x < other.dir.x;
  if (dir.y != other.dir.y) return dir.y < other.dir.y;
  if (dir.z != other.dir.z) return dir.z < other.dir.z;

  return false;
}

void Light::setLightGL(GLenum l) const
{
  float vpos[4];
  if (type == SolarLight) {
    vpos[0] = -dir.x;
    vpos[1] = -dir.y;
    vpos[2] = -dir.z;
    vpos[3] = 0.0;
  }
  else if (type == PointLight){
    vpos[0] = pos.x;
    vpos[1] = pos.y;
    vpos[2] = pos.z;
    vpos[3] = 1.0; 
  }
  glLightfv(l, GL_POSITION, vpos);
  glLightfv(l, GL_AMBIENT, ambient);
  glLightfv(l, GL_DIFFUSE, diffuse);
  glEnable(l);
}
