/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHXINTERSECTIONFINDER_HH
#define TOP10_GRAPHXINTERSECTIONFINDER_HH

#include "MeshNode.hh"
#include "math/Ray.hh"
#include <map>

namespace top10 {
namespace graphX {

class IntersectionFinder {
public:
  IntersectionFinder(Node* top_node, top10::math::Ray r) { find(top_node, r); }

  inline const std::map<double, top10::util::Ref<MeshNode> >* getResult() const { return &res; }

private:
  void find(Node* top_node, top10::math::Ray r);
  
  std::map<double, top10::util::Ref<MeshNode> > res;
};

}
}

#endif
