/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "GroupNode.hh"
#include <algorithm>

using namespace top10::graphX;

GroupNode::GroupNode()
{
}

Node* GroupNode::getChild(int i) const
{
  if (i<0 || i>=(int)children.size()) return 0;
  return children[i].getPtr();
}

void GroupNode::addChild(Node* n)
{
  if (n)
    children.push_back(NodeRef(n));
}

void GroupNode::removeChild(Node* n)
{
  NodeRefs tmp;
  tmp.reserve(children.size());

  for (NodeRefs::const_iterator it = children.begin(); it != children.end(); ++it)
    if (it->getPtr() != n)
      tmp.push_back(*it);

  children.swap(tmp);
}

void GroupNode::renderGL(const RenderingFeatures&, const RenderState&, const CameraNode&) const
{
}
