/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "GridNode.hh"

namespace top10 {
namespace graphX {

GridNode::GridNode():top10::graphX::LeafNode(), size_x(100.0), size_z(100.0), grid_unit(5.0)
{
}

void GridNode::buildRenderList(RenderState s, RenderList* l, const CameraNode&) const
{
  l->insert(std::make_pair(s, this));
}

void GridNode::renderGL(const RenderingFeatures& unused, const RenderState&, const CameraNode&) const
{
  // Would take for ever...
  if (grid_unit <= 0.0) return;
  
  // Would take too much time to draw...
  if (size_x/grid_unit >= 1e4) return;

  glBegin(GL_LINES);

  for (double x=-size_x/2.0; x<=size_x/2.0; x+=grid_unit)
  {
    glVertex3f(x, 0, -size_z/2.0);
    glVertex3f(x, 0, size_z/2.0);
  }

  for (double z=-size_z/2.0; z<=size_z/2.0; z+=grid_unit)
  {    
    glVertex3f(-size_x/2.0, 0, z);
    glVertex3f(size_x/2.0, 0, z);
  }    

  glEnd();

}

}
}
