/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHXCULLNODE_HH
#define TOP10_GRAPHXCULLNODE_HH

#include "GroupNode.hh"
#include "RenderState.hh"

namespace top10 {
namespace graphX {

class CullNode : public GroupNode
{
public:
  CullNode(): front_is_direct(true), culling(RenderState::NoCulling) {}

  inline void setCullDirect(bool b) { front_is_direct = true; }
  inline void setCulling(RenderState::Culling c) { culling = c; }
  
protected:
  inline void modifyRenderState(RenderState& s, const CameraNode&) const {
    s.setFront(front_is_direct);
    s.setCulling(culling);
  }

private:
  bool front_is_direct;
  RenderState::Culling culling;
};

}
}

#endif
