/*
  Top 10, a racing simulator
  Copyright (C) 2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_GRAPHX_CUBEMAP_HH
#define TOP10_GRAPHX_CUBEMAP_HH

#include "extras/GLee.h"

#include "util/RefCount.hh"

struct SDL_Surface;

namespace top10
{
namespace graphX
{

//! Wrapper class around a texture object representing a cube map.
class CubeMap: public top10::util::RefCount
{
public:
  enum Face { Front, Back, Left, Right, Top, Bottom };

public:
  //! Make an empty cube map
  CubeMap();

  //! Make a cube map using textures stored in specified files.
  CubeMap(const std::string& front, const std::string& back,
	  const std::string& left, const std::string& right,
	  const std::string& top, const std::string& bottom);

  //! Deallocates the texture object
  ~CubeMap();

  //! Set the image of a face
  void setFace(SDL_Surface* pixel_data, Face);

  //! Return the id of the texture object of this cube map
  GLuint getId() const;

private:
  //! The texture object used for the cube map
  GLuint id;
};

}
}
#endif
