#ifndef TOP10_GRAPHXCAMERANODE_HH
#define TOP10_GRAPHXCAMERANODE_HH

#include "LeafNode.hh"
#include "math/Frustum.hh"

namespace top10 {
namespace graphX {

// This should be called Camera, it's not actually part of the graph.
class CameraNode : public LeafNode
{
public:  
  inline const top10::math::Frustum& getView() const { return frustum; }
  inline void setView(const top10::math::Frustum& v) { frustum = v; }
  inline void setFOV(double f) { frustum.setFOV(f); }
  inline void setNear(double f) { frustum.setNear(f); }
  inline void setFar(double f) { frustum.setFar(f); }
  inline void setRatio(double f) { frustum.setRatio(f); }
  
protected:
  top10::math::Frustum frustum;
};

}
}

#endif
