#include <SDL/SDL.h>

namespace top10 {
  namespace util {
    //! Timer able to "slow down" time
    class SlowTime {
    public:
      SlowTime();
      //! slow down factor (if >1.0, otherwise it's a speed-up)
      inline void setSlowFactor(double sf) { slow_factor = sf; }
      inline double getSlowFactor() const { return slow_factor; }

      Uint32 getTicks();

    private:
      Uint32 last_t;
      double last_ret;
      double slow_factor;
      bool first;
    };

    extern SlowTime global_time;
  };
};

