/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_AUDIO_HH
#define TOP10_AUDIO_HH

#include <SDL.h>

#include "Kart.hh"
#include "SoundBuff.hh"

namespace top10 {
namespace ui_interactive {

/// Function called by the SDL sound system
void top10::ui_interactive::fill_audio(void* audio_device, Uint8* stream, int len);

class AudioDevice {
public:
	/**
	  Create an uninitialised audio device.
	  You have to call setKart() prior to first use.
	*/
	AudioDevice();

	/**
	  Create a ready-to-use audio device.
	*/
	AudioDevice(Kart*);
	
	/**
	  Set the kart. Sound is generated with respect to a Kart
	*/
	void setKart(Kart*);
	
	/**
	  Fill stream with audio samples.
	*/
	void render(Uint8* stream, int len);

	~AudioDevice();
private:
	void loadSamples();

private:
	/// Our kart
	Kart* kart;
	
	/**
	 Sound buffers containing a skidding wheel sound
	*/
	SoundBuffer<Sint16>* left_wheel_audio;
	SoundBuffer<Sint16>* right_wheel_audio;
	Uint8* sdl_tyre_audio;

	/**
	 Sound of the engine
	*/
	SoundBuffer<Sint16>* engine_audio;
	Uint8* sdl_engine_audio;
};

};	// ui_interactive
};	// top10

#endif
