/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "math/Curve.hh"

namespace top10 {
  namespace helpers {
    class Polygon;
  }

  namespace ui_interactive {

    class TrackSides
    {
    public:
      TrackSides(const top10::helpers::Polygon& left,
		 const top10::helpers::Polygon& right);

      /// Returns the distance from the pointer to the left side of the track
      double getLeftDistance() const;

      /// Returns the distance from the pointer to the right side of the track
      double getRightDistance() const;

      /**
	 Returns the "average" distance covered to reach the pointer from the
	 starting line
      */
      double getDistance() const;

      /**
	 Express the coordinates of the pointer in track's coordinates
      */
      void getTrackCoord(double& len, double& side) const;

      /**
	 Puts the pointer somewhere on the track.
      */
      void setPointer(double x, double y);

    private:
      top10::math::CurveND left_side;
      top10::math::CurveND right_side;

      double pointer_x;
      double pointer_y;
    };

  };
};
