/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef FILE_MENU_HH
#define FILE_MENU_HH

#include "UIPanel.hh"
#include <string>

namespace top10 {
  namespace ui_interactive {

    //! Show a list of files
    class FileMenu: public UIPanel::Menu {
    public:

      //! Abstract class for the action to perform when a file is selected
      class Notifier {
      public:
	virtual void fileSelected(std::string font) =0;
	virtual ~Notifier() {}
      };

      //! Constructor
      /*!
	\param p The path to the list of files to show (relative to the installation path)
	\param ext The extension of files to show. If empty, all files are shown.
       */
      FileMenu(UIPanel* p, Notifier* n, std::string pat, std::string ext):
	UIPanel::Menu(p), notifier(n), path(pat), extension(ext)
      {
	buildFileList();
      }

      void selected();

    private:
      void buildFileList();

      Notifier* notifier;
      std::string path;
      std::string extension;
    };
  };
};

#endif
