/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_UI_EVENT_HH
#define TOP10_UI_EVENT_HH

#include <SDL.h>
#include <iostream>
#include "Controls.hh"

namespace top10 {
  namespace ui_interactive {
    struct Event {
      Uint32 timestamp;
      Action action;
      Sint16 value;
    };

    inline std::ostream& operator<<(std::ostream& out, Event ev) {
      out<<ev.timestamp<<" "<<ev.action<<" "<<ev.value;
      return out;
    }

    inline std::istream& operator>>(std::istream& in, Event& ev) {
      in>>ev.timestamp>>ev.action>>ev.value;
      return in;
    }

  };
};

#endif
