/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "TrackDlg.hh"
#include "util/PathFinder.hh"
#include "util/UserFile.hh"

#include <qapplication.h>

int main(int argc, char** argv)
{
  try {
    top10::util::PathFinder::addPath("data");
    top10::util::PathFinder::addPath("data/textures");
    top10::util::PathFinder::addPath("data/meshes");
    top10::util::PathFinder::addPath("data/tracks");
    top10::util::PathFinder::addPath("data/sounds");
    top10::util::PathFinder::addPath("data/karts");
    top10::util::PathFinder::addPath("data/fonts");
    top10::util::PathFinder::addPath(top10::util::UserFile::getPath());
    top10::util::UserFile::makePath(); // Just in case it does not exist.
    top10::util::PathFinder::addPath("data/defaults");
    
    QApplication app(argc, argv);
    TrackDlg* main_dlg = new TrackDlg;
    app.setMainWidget(main_dlg);
    main_dlg->setCaption("Top10 track editor");
    main_dlg->show();
    int res = app.exec();
    delete main_dlg;
    return res;
  }
  catch(std::string e) {
    std::cerr<<"Uncaught exception: "<<e<<std::endl;
  }
  catch(...) {
    std::cerr<<"Unknown execption"<<std::endl;
  }
  return 1;
}
