/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TRACKEDIT_DLG_HH
#define TRACKEDIT_DLG_HH

#include "TrackDlgSkel.hh"
#include "MeshDlg.hh"
#include "SurfacesDlg.hh"
#include "DecorationsDlg.hh"
#include "CheckpointsDlg.hh"
#include "StartingAreaDlg.hh"

#include "../MainEditor.hh"
#include "../MeshEditor.hh"
#include "../SurfacesEditor.hh"
#include "../DecorationsEditor.hh"
#include "../CheckpointsEditor.hh"
#include "../StartingAreaEditor.hh"


//! The main dialog
class TrackDlg: public TrackDlgSkel
{
public:
  TrackDlg();

  void fileOpen();
  void fileSaveAs();
  void fileSave();
  void toggleMesh(bool);
  void toggleCheckpointsDlg(bool);
  void toggleStartingAreaDlg(bool);
  void toggleDecorations(bool);
  void toggleSurfaces(bool);

private:
  //! The name of the trk file
  std::string filename;

  MeshDlg         mesh_dlg;
  SurfacesDlg     surf_dlg;
  DecorationsDlg  deco_dlg;
  CheckpointsDlg  cps_dlg;
  StartingAreaDlg sa_dlg;

  top10::tracked::MainEditor         main_ed;
  top10::tracked::MeshEditor         mesh_ed;
  top10::tracked::SurfacesEditor     surf_ed;
  top10::tracked::DecorationsEditor  deco_ed;
  top10::tracked::CheckpointsEditor  cps_ed;
  top10::tracked::StartingAreaEditor sa_ed;

  top10::tracked::MainCamera camera;
};

#endif
