/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "StartingAreaDlg.hh"
#include <qlineedit.h>
#include <qstring.h>

StartingAreaDlg::StartingAreaDlg(): start_ed(0), viewer(0)
{
}

void StartingAreaDlg::pickPoint1()
{
  assert(start_ed);
  assert(viewer);
  try {
    start_ed->pickLeft();
    viewer->updateGL();
  }
  catch(std::string e) {}
  update();
}

void StartingAreaDlg::pickPoint2()
{
  assert(start_ed);
  assert(viewer);
  try {
    start_ed->pickRight();
    viewer->updateGL();
  }
  catch(std::string e) {}
  update();
}

void StartingAreaDlg::setPoint1()
{
  assert(start_ed);
  assert(viewer);

  double x,y,z;
  x = XEditSA1->text().toDouble();
  y = YEditSA1->text().toDouble();
  z = ZEditSA1->text().toDouble();

  start_ed->starting_area.setPoint1(top10::math::Vector(x,y,z));
  start_ed->setDirection();
  viewer->updateGL();
}

void StartingAreaDlg::setPoint2()
{
  assert(start_ed);
  assert(viewer);

  double x,y,z;
  x = XEditSA2->text().toDouble();
  y = YEditSA2->text().toDouble();
  z = ZEditSA2->text().toDouble();

  start_ed->starting_area.setPoint2(top10::math::Vector(x,y,z));
  start_ed->setDirection();
  viewer->updateGL();
}

void StartingAreaDlg::swapPoints()
{
  assert(start_ed);
  assert(viewer);

  start_ed->swap();
  start_ed->setDirection();
  viewer->updateGL();
  update();
}

void StartingAreaDlg::update()
{
  assert(start_ed);
  top10::math::Vector pt;
  pt = start_ed->starting_area.getPoint1();
  QString tmp;

  tmp.setNum(pt.x);
  XEditSA1->setText(tmp);
  tmp.setNum(pt.y);
  YEditSA1->setText(tmp);
  tmp.setNum(pt.z);
  ZEditSA1->setText(tmp);

  pt = start_ed->starting_area.getPoint2();
  tmp.setNum(pt.x);
  XEditSA2->setText(tmp);
  tmp.setNum(pt.y);
  YEditSA2->setText(tmp);
  tmp.setNum(pt.z);
  ZEditSA2->setText(tmp); 
}
