/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef DECORATIONS_DLG_HH
#define DECORATIONS_DLG_HH

#include "DecorationsDlgSkel.hh"
#include "../DecorationsEditor.hh"
#include "QGLView.hh"

class DecorationsDlg: public DecorationsDlgSkel {
public:
  DecorationsDlg();
  inline void setEditor(top10::tracked::DecorationsEditor* p) { deco_ed = p; }
  inline void setViewer(QGLView* p) { viewer = p; }

  void setCurrent(QListBoxItem*);
  void removeDeco();
  void pickMesh();

  void update();

private:
  top10::tracked::DecorationsEditor* deco_ed;
  QGLView* viewer;
};

#endif
