/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "StartingAreaDialog.hh"
#include "DialogManager.hh"

#define COORD_W 50

/*
 * Callbacks
 */

/*
 * Class implementation
 */
StartingAreaDialog::StartingAreaDialog(DialogManager* manager):
  Dialog(manager, "Starting Area")
{
  manager->registerDialog(this);
}

void StartingAreaDialog::populate()
{
  puInput* pt2_x = new puInput(0, H, COORD_W, 2*H);
  puInput* pt2_y = new puInput(0, 2*H, COORD_W, 3*H);
  puInput* pt2_z = new puInput(0, 3*H, COORD_W, 4*H);

  puInput* pt1_x = new puInput(0, 4.5*H, COORD_W, 5.5*H);
  puInput* pt1_y = new puInput(0, 5.5*H, COORD_W, 6.5*H);
  puInput* pt1_z = new puInput(0, 6.5*H, COORD_W, 7.5*H);

  puOneShot* pick2 = new puOneShot(COORD_W + 50, 2*H, "Pick");
  puOneShot* pick1 = new puOneShot(COORD_W + 50, 5.5*H, "Pick");

  puOneShot* swap = new puOneShot(COORD_W + 150, 3*H, "Swap");
}
