/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include <iostream>
#include <plib/pu.h>
#include "MasterDialog.hh"
#include "DialogManager.hh"

static void install_cb(puObject* ob)
{
  Dialog* dialog = (Dialog*)ob->getUserData();
  dialog->getManager()->setCurrentDialog(dialog->getName());
}

MasterDialog::MasterDialog(DialogManager* m):
  Dialog(m, "Master")
{
}

void MasterDialog::populate()
{
  unsigned int y=30;
  const unsigned int y_incr=30;

  puOneShot* new_button;
  for (DialogManager::DialogRegister::const_iterator it = getManager()->dialogs.begin();
       it != getManager()->dialogs.end();
       ++it) {
    new_button = new puOneShot(0, y, it->second->getName().c_str()); y+=y_incr;
    new_button->setCallback(install_cb);
    new_button->setUserData((void*)it->second);
  }
}

