/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_FILEMENU_DIALOG_HH
#define TOP10_FILEMENU_DIALOG_HH

#include <string>
#include "Dialog.hh"

class FileMenuDialog: public Dialog
{
public:
  FileMenuDialog(DialogManager*);

  void populate();

  void load();
  void save();
  void saveAs();

  inline void setFilename(std::string s) { filename = s; }
  inline std::string getFilename() const { return filename; }

private:
  std::string filename;
};

#endif
