/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_DIALOG_HH
#define TOP10_DIALOG_HH

#include <string>
#include "plib/pu.h"

class DialogManager;

class Dialog {
public:
  //! Use for placing widgets on the screen (vertical size of a "basic block")
  static const int H = 30;

public:
  Dialog(DialogManager* m, std::string n): manager(m), name(n), top(0) {}

  //! Create the pui dialog
  void install();

  //! Destroy the pui dialog
  inline void remove() {
    assert(top);
    puDeleteObject(top);
    top = 0;
  }

  inline void hide() { if (top) top->hide(); }
  inline void show() { if (top) top->reveal(); }
  inline std::string getName() const { return name; }
  inline DialogManager* getManager() const { return manager; }

  virtual ~Dialog() {}
  
private:
  DialogManager* manager;
  std::string name;
  puGroup* top;

private:
  virtual void populate() =0;
};

#endif
