/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/


#ifndef TOP10_TRACKED_STARTINGAREAEDITOR_HH
#define TOP10_TRACKED_STARTINGAREAEDITOR_HH

#include <string>
#include "Drawable.hh"
#include "MeshEditor.hh"
#include "racing/StartingArea.hh"

namespace top10 {
  namespace tracked {

    class StartingAreaEditor : public Drawable {
    public:
      StartingAreaEditor();
      inline void setMeshEditor(MeshEditor* p) { mesh_ed = p; }

      //! Pick the currently aimed point for the left point of the starting line
      void pickLeft();
      //! Pick ...
      void pickRight();
      //! Swap the left and right points
      void swap();
      //! Set the direction according after changing the left and right points
      void setDirection();

    public:
      top10::racing::StartingArea starting_area;

    protected:
      void drawGL_impl() const;

    private:
      MeshEditor* mesh_ed;
    };

  };
};
#endif

