/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "MainCamera.hh"

using namespace top10::tracked;

MainCamera::MainCamera():
  angleY(0.0), angleX(0.0)
{
  rotateX(-90);
  translate(top10::math::Vector(0, 100, 0));
  update();
}

void MainCamera::rotateY(double degrees)
{
  angleY += degrees;
}

void MainCamera::rotateX(double degrees)
{
  angleX += degrees;
}

void MainCamera::translate(top10::math::Vector t)
{
  setCenter(getCenter()+t);
}

void MainCamera::translateL(top10::math::Vector t)
{
  top10::math::Vector e0,e1,e2;
  e0 = getRight();
  e1 = getUp();
  e2 = -getDirection();
  top10::math::Matrix3 M3(e0,e1,e2);

  setCenter(getCenter() + M3*t);
}

void MainCamera::update()
{
  using top10::math::Vector;

  double aX = angleX*M_PI/180.0;
  double aY = angleY*M_PI/180.0;
  double caX = cos(aX);
  double saX = sin(aX);

  Vector dir_flat(caX, 0.0, -saX);
  Vector side_flat(-saX, 0.0, -caX);
  
  Vector dir = cos(aY)*dir_flat + Vector(0,sin(aY),0);
  Vector up = side_flat^dir;

  setDirection(dir, up);

  top10::ui_interactive::Frustum::update();
}
