/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Spring.hh"
#include <iostream>

using namespace top10::physX;

Spring::Spring(const char* name, bool debug):
  Debug(name, debug),
  k(0), l(0), f(0), old_dlen(0)
{
  pts[0] = 0;
  pts[1] = 0;
}

Spring::Spring(Point* A, Point* B, const char* name, bool debug):
  Debug(name, debug),
  k(0), l(0), f(0), old_dlen(0)
{
  pts[0] = A;
  pts[1] = B;
}

void Spring::update(double dt)
{
  if (is_debug()) {
    printDebugStart();
  }
  
  Vector v = pts[1]->pos - pts[0]->pos;
  // Compute new length
  double l2 = v.size();

  //  if (l2 > SMALL_VECTOR && ((l2 - l)*old_dlen>0.0)) {
  if (l2 > SMALL_VECTOR) {
    // Forces applied on points
    double dl = l-l2;
    Vector v_normalized =  v/l2;
    Vector f2 = v_normalized;
    f2 = f2*dl*k;

    Vector f1 = -f2;

    // Resisting forces
    Vector relative_speed = pts[1]->speed - pts[0]->speed;
    Vector r2 = v_normalized * (-v_normalized * relative_speed * f);
    Vector r1 = -r2;

    pts[1]->next_force += r2+f2;
    pts[0]->next_force += r1+f1;

    if (is_debug()) {
      debug_stream<<"reaction = "<<f1<<std::endl;
      debug_stream<<"friction = "<<r1<<std::endl;
    }
  }

  if (is_debug()) {
    printDebugEnd();
  }

  old_dlen = l2 - l;
}
