/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Engine.hh"

using namespace top10::physX;
using std::ostream;
using std::istream;

Engine::Engine(Wheel* left, Wheel* right,
	       double rps_max,
	       double rps_opt,
	       double ft_torque0,
	       double ft_torque1,
	       double nt_torque1,
	       double nt_torque2,
	       double brake_k):
  left_wheel(left), right_wheel(right),
  braking_torque(brake_k), accel(0), braking(0), w_speed(0.0), torque(0.0)
{
  full_accel_torque.addXY(0.0, ft_torque0);
  full_accel_torque.addXY(rps_opt, ft_torque1);
  full_accel_torque.addXY(rps_max, 0.0);
  
  no_accel_torque.addXY(0.0, 0.0);
  no_accel_torque.addXY(rps_opt, nt_torque1);
  no_accel_torque.addXY(rps_max, nt_torque2);
  
}

void Engine::dumpTo(ostream& out) const
{
  //TODO
}

void Engine::loadFrom(istream& in)
{
  //TODO
}

void Engine::update(double dt)
{
  double acc_torque(0.0), free_torque(0.0);

  acc_torque = full_accel_torque.getY(w_speed);
  free_torque = no_accel_torque.getY(w_speed);

  torque = acc_torque*accel + free_torque*(1 - accel);
  double brk_torque = braking*braking_torque;
  if (w_speed > 0.0) torque -= brk_torque;
  else torque += brk_torque;

  if (fabs(braking)>1 || fabs(accel)>1) {
    std::cerr<<"*** braking = "<<braking<<" accel = "<<accel<<std::endl;
  }

  left_wheel->setDriveTorque(torque/2.0);
  right_wheel->setDriveTorque(torque/2.0);
}
