/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_MATH_INTERSECT_HH
#define TOP10_MATH_INTERSECT_HH

#include "Plane.hh"
#include "Box.hh"
#include "Triangle.hh"

namespace top10 {
  namespace math {
    bool intersect(Box, Box);
    bool intersect(AxisAlignedBox, AxisAlignedBox);
    bool intersect(AxisAlignedBox, Box, bool try_other=true);
    inline bool intersect(Box b, AxisAlignedBox bb) { return intersect(bb, b); }

    bool intersect(Plane, Box);
    inline bool intersect(Box b, Plane p) { return intersect(p, b); }

    bool intersect(Triangle, Box);
    inline bool intersect(Box b, Triangle t) { return intersect(t, b); }

    bool intersect(Plane, AxisAlignedBox);
    inline bool intersect(AxisAlignedBox b, Plane p) { return intersect(p, b); }

    bool intersect(Triangle, AxisAlignedBox);
    inline bool intersect(AxisAlignedBox b, Triangle t) { return intersect(t, b); }

  };
};

#endif
