/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Vec2D.hh"

#include <cmath>

using top10::math::Vec2D;

Vec2D& Vec2D::operator+=(const Vec2D& other)
{
  x += other.x;
  y += other.y;
  return *this;
}

Vec2D& Vec2D::operator-=(const Vec2D& other)
{
  x -= other.x;
  y -= other.y;
  return *this;
}

Vec2D& Vec2D::operator/=(double c)
{
  x /= c;
  y /= c;
  return *this;
}

Vec2D& Vec2D::operator*=(double c)
{
  x *= c;
  y *= c;
  return *this;
}

Vec2D Vec2D::operator- ()
{
  return Vec2D(-x, -y);
}

double Vec2D::size2() const
{
  return x*x + y*y;
}

double Vec2D::size() const
{
  return sqrt( size2() );
}

double operator*(const Vec2D& a, const Vec2D& b)
{
  return a.x*b.x + a.y*b.y;
}

double operator^(const Vec2D& a, const Vec2D& b)
{
  return a.x*b.y - b.x*a.y;
}

Vec2D operator*(double d, Vec2D v)
{
  v*=d;
  return v;
}

Vec2D operator/(Vec2D v, double d)
{
  v/=d;
  return v;
}

bool intersection(const Vec2D& pt1, const Vec2D& dir1,
		  const Vec2D& pt2, const Vec2D& dir2,
		  Vec2D& out)
{
  // Check if they are parallel
  double dd = dir1^dir2;
  if (fabs(dd) < SMALL_VECTOR) return false;
  
  out = pt1 + (((pt2 - pt1)^dir2)/dd)*dir1;
  
  using std::cout;
  using std::endl;

  cout<<"pt2-pt1 "<<(pt2 - pt1)<<endl;
  cout<<"(pt2-pt1)^dir2 "<<((pt2 - pt1)^dir2)<<endl;
  cout<<"(((pt2 - pt1)^dir2)/dd) "<<(((pt2 - pt1)^dir2)/dd)<<endl;
  cout<<"(((pt2 - pt1)^dir2)/dd)*dir1 "<<((((pt2 - pt1)^dir2)/dd)*dir1)<<endl;
  
  return true;
}

bool identical(const top10::math::Vec2D& pt1,
	       const top10::math::Vec2D& pt2,
	       const top10::math::Vec2D& dir)
{
  return fabs((pt1 - pt2)^dir) < SMALL_VECTOR;
}
