/*
  Top 10, a racing simulator
  Copyright (C) 2000-2002  Deneux Johann
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Deneux Johann:       deneux@ifrance.com
*/

#ifndef TOP10_FAST_TRIANGULATION_HH
#define TOP10_FAST_TRIANGULATION_HH

#include <vector>

#include "math/Vertex.hh"
#include "ui_interactive/Triangle.hh"
extern "C" {
#include "extras/interface.h"
}

namespace top10 {
  namespace physX {
    class Surface;
  }

  namespace helpers {

    /**
       C++ wrapper around the functions for fast triangulation.
       See README.triangulation for more details. The triangulation routines
       were written by Narkhede A. and Manocha D. and is based on Seidel's
       Algorithm.
       \param outer Outer contour
       \param outer_is_direct true of outer contour is anti-clockwise
       \param hole Inner contour
       \param hole_is_direct true if inner contour is anti-clokwise
       \param surface surface
       \param r Red component
       \param g Green Component
       \param b Blue Component
    */
    class Seidel: public top10::ui_interactive::TriangleSet
    {
    public:
      Seidel(const std::vector<Vertex> outer, bool outer_is_direct,
	     const std::vector<Vertex> hole, bool  hole_is_direct,
	     const top10::physX::Surface& surface,
	     unsigned char r, unsigned char g, unsigned char b,
	     bool use_texture = false, std::string texture_name = "None");
    };
    
  };
};

#endif
