/*
  Top 10, a racing simulator
  Copyright (C) 2000-2002  Deneux Johann
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Deneux Johann:       deneux@ifrance.com
*/

#include "helpers/FastTriangulation.hh"
#include "util/CleanPtr.hh"
#include "physX/Surface.hh"

using top10::helpers::Seidel;
using namespace top10;

Seidel::Seidel(const std::vector<Vertex> outer, bool outer_is_direct,
	       const std::vector<Vertex> hole, bool hole_is_direct,
	       const top10::physX::Surface& surface,
	       unsigned char r, unsigned char g, unsigned char b,
	       bool use_texture, std::string texture_name):
  TriangleSet()
{
  using util::CleanPtr;

  typedef double TwoDoubles[2];

  /*
   * Build the vertex list
   */

  //FIXME: CleanPtr::~CleanPtr will call delete, not delete[]
  CleanPtr<TwoDoubles> vertices = new TwoDoubles[outer.size() + hole.size() +1];
  TwoDoubles *pvert = vertices.get() +1;

  std::vector<Vertex> V_vertices;

  if (!outer_is_direct) {
    for (std::vector<Vertex>::const_reverse_iterator p = outer.rbegin();
	 p != outer.rend();
	 ++p, ++pvert) {
      (*pvert)[0] = p->x;
      (*pvert)[1] = -p->z;        // - sign to respect directness
      V_vertices.push_back(*p);
    }
  }
  else {
    for (std::vector<Vertex>::const_iterator p = outer.begin();
	 p != outer.end();
	 ++p, ++pvert) {
      (*pvert)[0] = p->x;
      (*pvert)[1] = -p->z;
      V_vertices.push_back(*p);
    }
  }

  if (!hole_is_direct) {
    for (std::vector<Vertex>::const_iterator p = hole.begin();
	 p != hole.end();
	 ++p, ++pvert) {
      (*pvert)[0] = p->x;
      (*pvert)[1] = -p->z;
      V_vertices.push_back(*p);
    }
  }
  else {
    for (std::vector<Vertex>::const_reverse_iterator p = hole.rbegin();
	 p != hole.rend();
	 ++p, ++pvert) {
      (*pvert)[0] = p->x;
      (*pvert)[1] = -p->z;
      V_vertices.push_back(*p);
    }
  }

  /*
   * Number of vertices in each contour
   */

  int n_vertices[2];
  n_vertices[0] = outer.size();
  n_vertices[1] = hole.size();

  /*
   * Place for result
   */
  typedef int ThreeInts[3];
  CleanPtr<ThreeInts> triangles_idx = new ThreeInts[outer.size() + hole.size()];
  
  /*
   * Actual triangulation
   */
  int n_triangles = triangulate_polygon(2, n_vertices, vertices.get(), triangles_idx.get());

  /*
   * Translate back to top10 data structures
   */

  ui_interactive::Triangle triangle;
  triangle.r = r;
  triangle.g = g;
  triangle.b = b;
  triangle.top10::physX::Surface::operator=(surface);
  triangle.tex_used = use_texture;
  if (use_texture) {
    top10::ui_interactive::TriangleSet::texture_names_map::const_iterator it;
    it = top10::ui_interactive::TriangleSet::texture_names.find(texture_name);

    if (it == top10::ui_interactive::TriangleSet::texture_names.end())
      throw top10::util::Error("Texture "+texture_name+" not found");

    triangle.tex_name = it->second;
  }

  for (int i = 0; i<n_triangles; ++i) {
    for (int j=0; j<3; ++j) {
      triangle.p[j] = V_vertices[(triangles_idx.get())[i][j] - 1];
      triangle.s[j] = triangle.p[j].x;
      triangle.t[j] = triangle.p[j].z;
    }
    push_back(triangle);
  }
}
