/*
  Top 10, a racing simulator
  Copyright (C) 2003  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_HELPERS_3DS_READ_HH
#define TOP10_HELPERS_3DS_READ_HH

#include "PolygonSet.hh"

#include <lib3ds/file.h>
#include <lib3ds/node.h>

namespace top10 {
  namespace helpers {
    class Read3DS: public PolygonSet {
    public:
      Read3DS(const char* filename);

    private:
      void loadNode(Lib3dsFile* file, Lib3dsNode* node, top10::math::Matrix4 trans);
    };
  };
};

#endif
