/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include <assert.h>
#include <stdio.h>
#include <GL/glu.h>

extern void* malloc(int);

#include "sdl2gl.h"


#define TESTGLERR(txt)	\
	{\
	int glerr = glGetError();\
	if (glerr) {\
		fprintf(stderr, "OpenGL error: " txt ": %s\n", gluErrorString(glerr));\
	}}


static int roundPow(int x)
{
  int i;
  assert(x > 0);

  for (i=0; x; ++i, x >>= 1);
  x = 1;
  for (; i>1; --i, x <<= 1);

  return x;
}

GLuint createGLfromSDL(SDL_Surface* surface, int w, int h)
{
  void* buff = 0;
  int gluerr;
  GLuint texture_name;
  SDL_Surface *image;
  SDL_Rect area;
  Uint32 saved_flags;
  Uint8  saved_alpha;

  if (w == 0) w = roundPow(surface->w);
  if (h == 0) h = roundPow(surface->h);

  
  image = SDL_CreateRGBSurface(
			       SDL_SWSURFACE,
			       w, h,
			       32,
#if SDL_BYTEORDER == SDL_LIL_ENDIAN /* OpenGL RGBA masks */
			       0x000000FF,
			       0x0000FF00,
			       0x00FF0000,
			       0xFF000000
#else
			       0xFF000000,
			       0x00FF0000,
			       0x0000FF00,
			       0x000000FF
#endif
			       );
  if ( image == NULL ) {
    return 0;
  }

  /* Save the alpha blending attributes */
  saved_flags = surface->flags&(SDL_SRCALPHA|SDL_RLEACCELOK);
  saved_alpha = surface->format->alpha;
  if ( (saved_flags & SDL_SRCALPHA) == SDL_SRCALPHA ) {
    SDL_SetAlpha(surface, 0, 0);
  }
  
  /* Copy the surface into the GL texture image */
  area.x = 0;
  area.y = 0;
  area.w = surface->w;
  area.h = surface->h;
  SDL_BlitSurface(surface, &area, image, &area);
  
  /* Restore the alpha blending attributes */
  if ( (saved_flags & SDL_SRCALPHA) == SDL_SRCALPHA ) {
    SDL_SetAlpha(surface, saved_flags, saved_alpha);
  }

  /* resize the image to a power of a 2 */
  buff = malloc(w * h * 4);
  assert(buff);
  gluerr = gluScaleImage( GL_RGBA, image->w, image->h, GL_UNSIGNED_BYTE,
			  image->pixels,
			  w, h, GL_UNSIGNED_BYTE, buff );
  if (gluerr) {
    fprintf(stderr, "GLU error: %s\n", gluErrorString(gluerr));
  }
  
  /* create the OpenGL Texture object */
  glGenTextures(1, &texture_name);
  TESTGLERR("gen");
  glBindTexture(GL_TEXTURE_2D, texture_name);
  TESTGLERR("bind");

  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  TESTGLERR("tex parameter");

  glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, w, h, 0, GL_RGBA, GL_UNSIGNED_BYTE, buff);
  TESTGLERR("tex");  
  //  gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, w, h, GL_RGBA, GL_UNSIGNED_BYTE, buff);
  SDL_FreeSurface(image); /* No longer needed */

  return texture_name;
}
