/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/


#ifndef TOP10_ERROR_HH
#define TOP10_ERROR_HH

#include <string>
#include <iostream>

namespace top10 {
  namespace util {

    class Error: public std::string {
    public:
      Error(): std::string("Unknown error") {};
      Error(const char *msg): std::string(msg) {};
      Error(const std::string& msg): std::string(msg) {};
    };

    /* Macros to use inside a class declaration */
    //Note: gcc < 2.95.2 does not compile this
#define DECL_ERROR(name) \
class name: public top10::util::Error {\
public:\
name(): top10::util::Error(std::string(": -")) {};\
name(const char* msg): top10::util::Error(std::string(std::string(": ") + std::string(msg))) {};\
name(const std::string& msg): top10::util::Error(std::string(std::string(": ") + msg)) {};\
}

#define DECL_ERROR_FROM(name, parent)\
class name: public parent {\
public:\
name(): parent(std::string(": -")) {};\
name(const char* msg): parent(std::string(std::string(": ") + std::string(msg))) {};\
name(const std::string& msg): parent(std::string(std::string(": ") + msg)) {};\
}
  };
};

#endif
