/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include <iostream>
#include "RefCount.hh"

namespace top10 {
namespace util {

RefCount::RefCount(): ref_count(0)
#ifndef NDEBUG
  ,first_use(true),
  salt(0xdeadaed)
#endif
{
  assert(first_use);
  assert(salt == 0xdeadaed);  
}

RefCount::RefCount(const RefCount&): ref_count(0)
#ifndef NDEBUG
  ,first_use(true),
  salt(0xdeadaed)
#endif
{
  assert(first_use);
  assert(salt == 0xdeadaed);  
}

void RefCount::use() const {
#ifndef NDEBUG
  assert(salt == 0xdeadaed);
  if (first_use && ref_count != 0) {
    std::cerr<<__FILE__<<":"<<__LINE__<<" first_use and ref_count != 0"<<std::endl;
    abort();
  }
  if (!first_use && ref_count == 0) {
    std::cerr<<__FILE__<<":"<<__LINE__<<" !first_use ref_count == 0"<<std::endl;
    abort();
  }
  assert(ref_count >= 0);
  first_use = false;
#endif    
  ++ref_count;
}
  
bool RefCount::release() const {
  assert(salt == 0xdeadaed);
  assert(ref_count > 0);
  --ref_count;
  return ref_count == 0;
}

#ifndef NDEBUG
RefCount::~RefCount() {
  assert(ref_count >= 0);
  assert(ref_count <= 0);
  assert(salt == 0xdeadaed);
  salt = 0;
}
#endif

}
}
