#ifndef TOP10_UTIL_RANGE_HH
#define TOP10_UTIL_RANGE_HH

#include <list>
#include <utility>

namespace top10 {
  namespace util {
    //! An union of intervals
    class Range
    {
    public:
      //! Range [first, last]
      Range(int first, int last);
      //! Empty range
      Range();

      void insert(int first, int last);
      void remove(int first, int last);

      class const_iterator
      {
      public:
	const_iterator& operator++();
	const_iterator& operator--();
	int operator*() const;
	bool operator==(const const_iterator&) const;
	inline bool operator!=(const const_iterator& o) const {return !operator==(o);}

      private:
	const Range* range;
	std::list< std::pair< int, int> >::const_iterator p_unit;
	int val;

	friend class Range;
      };

      const_iterator begin() const;
      const_iterator end() const;

    private:
      std::list< std::pair< int, int> > units;

      friend class const_iterator;
    };
  };
};

#endif
