/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_UTIL_PATH_FINDER_HH
#define TOP10_UTIL_PATH_FINDER_HH

#include <list>
#include <string>

namespace top10 {
  namespace util {
    class PathFinder {
    public:
      //! Looks for a file and return its complete path, or the empty string if not found
      std::string find(std::string filename);

      //! Add a directory to the search path
      void addPath(std::string path);

      static PathFinder defaultPathFinder();

      static std::string getPath(std::string filename);
      //! remove everything that's before the last /
      static std::string basename(std::string);
                  
    private:
      //! return true iff the path is absolute
      static bool isAbsolute(std::string);

      //! Remove everything that's on the left of the first /
      static std::string strip(std::string);

      typedef std::list<std::string> Paths;
      Paths paths;
    };
  };
};

#endif
