/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Debug.hh"
#include <iostream>
#include <cassert>

std::ostream& top10::util::Debug::debug_stream(std::cerr);
std::set<const top10::util::Debug*> top10::util::Debug::members;

top10::util::Debug::Debug(const char* name, bool debug):
  _debug(debug), _name(name)
{
  if (debug) {
    printDebugStart();
    debug_stream<<"Construction"<<std::endl;
    printDebugEnd();
  }
  members.insert(this);
}

top10::util::Debug::~Debug()
{
  std::set<const Debug*>::iterator f = members.find(this);
  assert(f != members.end());
  members.erase(f);
  if (_debug) {
    printDebugStart();
    debug_stream<<"Destruction"<<std::endl;
    printDebugEnd();
  }
}

void top10::util::Debug::printDebugStart() const
{
  debug_stream<<"DEBUG "<<_name<<" {"<<std::endl;
}

void top10::util::Debug::printDebugEnd() const
{
  debug_stream<<"}"<<std::endl;
}
