/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef UIPANEL_HH
#define UIPANEL_HH

#include <vector>
#include <string>
#include <SDL/SDL.h>
#include <plib/fnt.h>

namespace top10 {
  namespace ui_interactive {
    class UIPanel {
    public:
      class Menu {
      protected:
	//! Entries of this menu
	std::vector<std::string> entries;

	//! Links to submenus (if any, 0 otherwise)
	/*! links.size() must be same as entries.size() */
	std::vector<Menu*> links;

      public:
	Menu(UIPanel*);

	//! By default: show linked menu.
	virtual void selected();

	/*! By default:
	  Key up -> move to the previous menu entry
	  Key down -> ... next entry
	  Space -> Select current entry
	*/
	virtual void event(SDL_Event);

	//! Move to next entry
	int nextEntry();
	//! Move to previous entry
	int prevEntry();
	//! Get the current entry number
	inline int getEntryN() const { return entry_n; }

	//! By default: draw one line for each entry
	virtual void updateGL(fntRenderer& texout, const fntTexFont&);

	virtual ~Menu() {}

      protected:
	UIPanel* panel;
	int entry_n;
      };

      UIPanel();

      void setFrontMenu(Menu* m) { frontMenu = m; }
      void setFont(std::string font);

      //! Return pointer to current menu, or 0 if the panel is not active.
      inline Menu*       getCurrentMenu()       { return currentMenu; }
      inline const Menu* getCurrentMenu() const { return currentMenu; }

      //! Change the current menu.
      inline void setMenu(Menu* m) {
	currentMenu = m;
	if (currentMenu) SDL_EnableUNICODE(1);
	else SDL_EnableUNICODE(-1);
      }

      inline void hide() { setMenu(0); }
      inline bool isVisible() const { return getCurrentMenu() != 0; }

      //! Handle events: Forward them to the current menu
      /*! ESC keypresses are caught. They are used to show/hide the panel. */
      void event(SDL_Event);
      inline void resizeEvent(int w, int h) { window_w = w; window_h = h; }

      void updateGL();

      inline int getWindowWidth() const { return window_w; }
      inline int getWindowHeight() const { return window_h; }

    private:
      Menu* currentMenu;
      Menu* frontMenu;

      fntRenderer texout;
      fntTexFont font;

      int window_w;
      int window_h;
    };
  };
};

#endif
