/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef MAIN_MENU_HH
#define MAIN_MENU_HH

#include "UIPanel.hh"
#include "Controls.hh"
#include "FileMenu.hh"
#include "YesNoMenu.hh"
#include "audio.hh"
#include "GameManager.hh"
#include "util/PathFinder.hh"
#include "graphX/Renderer.hh"
#include <iostream>

namespace top10 {
  namespace ui_interactive {
    class MainMenu: public UIPanel::Menu {
    public:
      MainMenu(UIPanel*, ActionMapping* actions, top10::graphX::Renderer* render, AudioDevice* audio);
      ~MainMenu();
      
      inline bool getQuit() const { return quit; }
      GameManager* getGameManager() { return &game_manager; }

    private:
      //! Create a training session when a track file is selected
      class TrackFileNotifier: public FileMenu::Notifier {
      public:
	TrackFileNotifier(MainMenu* menu);
	void entrySelected(std::string track_file, FileMenu::EntryType);
      private:
	MainMenu* menu;
      };

      //! Set the model of the kart to draw
      class KartNotifier: public FileMenu::Notifier {
      public:
	KartNotifier(MainMenu* menu);
	void entrySelected(std::string kart_file, FileMenu::EntryType);
      private:
	MainMenu* menu;
      };

      TrackFileNotifier track_notifier;
      KartNotifier kart_notifier;
      YesNoMenu::BoolNotifier quit_notifier;

      bool quit;
      GameManager game_manager;
      std::string kart_model_name;
      top10::util::PathFinder path_finder;
      
      friend class TrackFileNotifier;
      friend class KartNotifier;
    };
  };
};

#endif
