/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "MainMenu.hh"
#include "ControlsMenu.hh"
#include "util/PathFinder.hh"
#include <fstream>
#include <time.h>
#include <sstream>

using namespace top10::ui_interactive;

MainMenu::MainMenu(UIPanel* p, ActionMapping* actions, top10::graphX::Renderer* render, AudioDevice* audio):
  UIPanel::Menu(p),
  track_notifier(this),
  quit_notifier(&quit), kart_notifier(this),
  quit(false),
  game_manager(render, audio),
  kart_model_name("default/default.parts")
{
  entries.push_back("Training session");
  links.push_back(new FileMenu(p, &track_notifier, "data/track_data", "", FileMenu::Dir));
  
  entries.push_back("Load Kart (next session)");
  links.push_back(new FileMenu(p, &kart_notifier, "data/kart_data", "", FileMenu::Dir));  
  
  entries.push_back("Controls");
  links.push_back(new ControlsMenu(p, actions));
  
  entries.push_back("Quit");
  links.push_back(new YesNoMenu(p, &quit_notifier));
}

MainMenu::~MainMenu()
{
  while (!links.empty()) {
    if (links.back()) {
      delete links.back();
    }
    links.pop_back();
  }
}

MainMenu::TrackFileNotifier::TrackFileNotifier(MainMenu* m):
  menu(m)
{
}

void MainMenu::TrackFileNotifier::entrySelected(std::string dirname, FileMenu::EntryType t)
{
  assert(t == FileMenu::Dir);
  std::string bn = top10::util::PathFinder::basename(dirname);
  std::string file = dirname+"/"+bn+".trk";
  menu->getGameManager()->createTrainingSession(file, menu->kart_model_name, false);
  menu->getGameManager()->startGame();
}

MainMenu::KartNotifier::KartNotifier(MainMenu* m):
  menu(m)
{
}

void MainMenu::KartNotifier::entrySelected(std::string dirname, FileMenu::EntryType t)
{
  assert(t == FileMenu::Dir);
  std::string bn = top10::util::PathFinder::basename(dirname);
  std::string file = dirname+"/"+bn+".parts";
  menu->kart_model_name = file;
}
