/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "topListBox.hh"

#define WIDW 20

/*
 * Callbacks
 */
static void up_cb(puObject* ob)
{
  topListBox* lb = (topListBox*)ob->getUserData();
  lb->goUp();
}

static void dawn_cb(puObject* ob)
{
  topListBox* lb = (topListBox*)ob->getUserData();
  lb->goDown();
}

static void slider_cb(puObject* ob)
{
  topListBox* lb = (topListBox*)ob->getUserData();
  float val;
  ob->getValue(&val);
  lb->go(1.0-val);
}

/*
 * Class implementation
 */

topListBox::topListBox(int x, int y, int maxx, int maxy, std::set<std::string> entries):
  puListBox(x,y,maxx-WIDW,maxy)
{
  // Setup the list
  list_n = entries.size();
  list_args = new char*[list_n +1];
  int i=0;
  for (std::set<std::string>::const_iterator it = entries.begin();
       it != entries.end();
       ++it, ++i) {
    list_args[i] = new char[it->size() +1];
    strncpy(list_args[i], it->c_str(), it->size()+1);
  }
  list_args[i] = 0;
  newList(list_args);

  // The arrows
  up = new puArrowButton(maxx-WIDW, maxy-WIDW, maxx, maxy, PUARROW_UP);
  up->setUserData(this);
  up->setCallback(up_cb);

  down = new puArrowButton(maxx-WIDW, y, maxx, y+WIDW, PUARROW_DOWN);
  down->setUserData(this);
  down->setCallback(dawn_cb);

  // The slider
  slider = new puSlider(maxx-WIDW, y+WIDW, (maxy-y)-2*WIDW, TRUE, WIDW);
  slider->setUserData(this);
  slider->setCallback(slider_cb);
  slider->setSliderFraction((float)getNumVisible()/list_n);

  go(0.0);
}

void topListBox::goUp()
{
  int n = getTopItem();
  if (n>0) {
    --n;
    setTopItem(n);
  }
  slider->setValue(1.0f-(float)n/(getNumItems()-getNumVisible()));
}

void topListBox::goDown()
{
  int n = getTopItem();
  if (n < getNumItems()- getNumVisible()) {
    ++n;
    setTopItem(n);
  }
  slider->setValue(1.0f-(float)n/(getNumItems()-getNumVisible()));
}

void topListBox::go(float val)
{
  int n = (int)(val * (getNumItems()-getNumVisible()));
  setTopItem(n);
  slider->setValue(1.0f-val);
}

topListBox::~topListBox()
{
  for (int i=0; i<list_n; ++i) delete[] list_args[i];
  delete[] list_args;
}
